import { system, world } from "@minecraft/server";
import { ConstantData } from "../ConstantData";

function timeSettings(){
    let alwaysday;
    let alwaysnight;
    if(ConstantData.dayLength<=0){
        alwaysnight = true
    }else if(ConstantData.dayLength>=100){
        alwaysday = true;
    }else {
        alwaysday = false;
    };
    if(ConstantData.nightLength<=0){
        alwaysday = true;
    }else if(ConstantData.nightLength >=100){
        alwaysnight = true;
    }else {
        alwaysnight = false;
    };
    if(alwaysday==true&&alwaysnight==false){
        return "day";
    }else if(alwaysday==false&&alwaysnight==true){
        return "night";
    }else if(alwaysday==true&&alwaysnight==true){
        return "none";
    }else if(alwaysday==false&&alwaysnight==false){
        return "normal";
    };
};
function whitelist(){
    if(ConstantData.whitelist==true){
        world.afterEvents.playerSpawn.subscribe((player)=>{
            if(ConstantData.whitelistedPlayers.includes(player.player.name)){
                return;
            }else {
                player.player.runCommand("kick @s");
            };
        });
    }else {
        return;
    };
};
/**
 * Sends a scripting side message. The message will be sent to whereever and whoever defined in ConstantData
 * @param {string} msg The message to send
 * @returns {void}
 */
export function report(msg){
    switch(ConstantData.logPermission){
        case "Operator": world.getAllPlayers().forEach((player)=>{if(player.isOp()){player.sendMessage(msg)};}); console.warn(msg); break;
        case "Member": world.sendMessage(msg); console.warn(msg); break;
        case "Console": console.warn(msg); break;
        case "Server": console.warn(msg); break;
        default: console.warn(msg); break;
    };
    return;
};
function spawn(){
    world.afterEvents.playerSpawn.subscribe((ev)=>{
        if(ev.initialSpawn==true){
            ev.player.teleport(ConstantData.initialSpawnPoint);
            return;
        };
        let tpA;
        if(ConstantData.adminSpawnPoint == true){
            tpA = ConstantData.initialSpawnPoint;
        }else if(ConstantData.adminSpawnPoint==false){
            tpA = false;
        };
        let tpM;
        if(ConstantData.userSpawnPoint == false){
            tpM = false;
        }else if(ConstantData.userSpawnPoint == true){
            tpM = ConstantData.initialSpawnPoint;
        };
        if(ev.player.isOp()==true){
            switch(tpA){
                case false: break;
                case true: ev.player.teleport(ConstantData.initialSpawnPoint); break;
                default: ev.player.teleport(ConstantData.adminSpawnPoint); break;
            };
            return;
        }else {
            switch(tpM){
                case true: ev.player.teleport(ConstantData.initialSpawnPoint); break;
                case false: break;
                default: ev.player.teleport(ConstantData.userSpawnPoint); break;
            };
            return;
        };
    });
};
function timeController(){
    let timeMultiplier;
    let time;
    switch(timeSettings()){
        case "day": time = 6000; break;
        case "night": time = 18000; break;
        case "none": timeMultiplier = 0; break;
        case "normal": timeMultiplier = 1; break;
        default: timeMultiplier = 1; break;
    };
    if(!time){
        return timeMultiplier;
    }else if(!timeMultiplier){
        world.setTimeOfDay(time); world.getDimension("overworld").runCommandAsync("gamerule doDaylightCycle false");
        return undefined;
    };
};
function timePass(){
    let mul = timeController();
    if(!mul){
        return;
    }else {
        if(mul==0){
            world.getDimension("overworld").runCommandAsync("gamerula doDaylightCycle false");
        }else {
            // 20 * 60 = 1200, 1200 * 20 == 24000 (minutes*secondsInMinute*ticksInSecond)
            // let dayTimeInTicks = (ConstantData.dayLength+ConstantData.nightLength)*60*20;
            // default = 24000
            // let division = Math.round(dayTimeInTicks/24000);
            setCustomDayNightLength(ConstantData.dayLength, ConstantData.nightLength);
        };
    };
};
function setCustomDayNightLength(dayLength, nightLength) {
    // Validate input to prevent negative or zero lengths
    if (dayLength <= 0 || nightLength <= 0) {
        console.log("Invalid input: Day and night lengths must be greater than 0.");
        return;
    }
    dayLength = dayLength*60;
    nightLength = nightLength*60;
    let currentTick = 0;

    // Function to set time based on current tick
    function setTime() {
        // Calculate the time based on the current tick
        let newTime;
        if (currentTick <= dayLength) {
            // During the day, smoothly transition from 0 to 12000
            newTime = Math.floor((currentTick / dayLength) * 12000);
        } else {
            // During the night, smoothly transition from 12000 to 24000
            newTime = Math.floor(12000 + ((currentTick - dayLength) / nightLength) * 12000);
        }

        // Ensure newTime is an integer
        newTime = Math.floor(newTime);

        // Set the time as an integer
        world.setTimeOfDay(newTime);

        // Increment the tick for the next iteration with a more gradual pace
        currentTick = (currentTick + 1) % (dayLength + nightLength);
    }

    // Run the setTime function at regular intervals
    const tickInterval = 20; // Adjust this as needed (ticks per second)
    system.runInterval(setTime, tickInterval);
}

export function runConstant(){
    system.run(()=>{spawn(); whitelist(); timeController(); timePass()});
};